/*
 * Decompiled with CFR 0.152.
 */
package hu.uw.pallergabor.dedexer;

import hu.uw.pallergabor.dedexer.DexParser;
import hu.uw.pallergabor.dedexer.DexPointerBlock;
import hu.uw.pallergabor.dedexer.DexStringIdsBlock;
import hu.uw.pallergabor.dedexer.DexTypeIdsBlock;
import java.io.IOException;

public class DexFieldIdsBlock
extends DexParser {
    private FieldHolder[] fields;
    private DexPointerBlock dexPointerBlock = null;
    private DexStringIdsBlock dexStringIdsBlock = null;
    private DexTypeIdsBlock dexTypeIdsBlock = null;

    @Override
    public void parse() throws IOException {
        int fieldsSize = (int)this.dexPointerBlock.getFieldIdsSize();
        this.file.seek(this.dexPointerBlock.getFieldIdsOffset());
        this.fields = new FieldHolder[fieldsSize];
        int i = 0;
        while (i < fieldsSize) {
            int classTypeIdx = this.read16Bit();
            int typeIdx = this.read16Bit();
            int nameStringIdx = (int)this.read32Bit();
            FieldHolder fieldHolder = new FieldHolder();
            fieldHolder.className = this.dexTypeIdsBlock.getClassName(classTypeIdx);
            fieldHolder.fieldName = this.dexStringIdsBlock.getString(nameStringIdx);
            fieldHolder.type = this.dexTypeIdsBlock.getType(typeIdx);
            this.fields[i] = fieldHolder;
            this.dump("field[" + i + "]: " + this.getField(i));
            ++i;
        }
    }

    public int getFieldsSize() {
        return (int)this.dexPointerBlock.getFieldIdsSize();
    }

    public String getField(int idx) {
        FieldHolder fieldHolder = this.fields[idx];
        StringBuilder b = new StringBuilder();
        b.append(fieldHolder.className);
        b.append('.');
        b.append(fieldHolder.fieldName);
        b.append(' ');
        b.append(fieldHolder.type);
        return new String(b);
    }

    public String getFieldName(int idx) {
        FieldHolder fieldHolder = this.fields[idx];
        return fieldHolder.fieldName;
    }

    public String getFieldShortName(int idx) {
        FieldHolder fieldHolder = this.fields[idx];
        StringBuilder b = new StringBuilder();
        b.append(fieldHolder.fieldName);
        b.append(' ');
        b.append(fieldHolder.type);
        return new String(b);
    }

    public String getFieldType(int idx) {
        FieldHolder fieldHolder = this.fields[idx];
        return fieldHolder.type;
    }

    public void setDexPointerBlock(DexPointerBlock dexPointerBlock) {
        this.dexPointerBlock = dexPointerBlock;
    }

    public void setDexStringIdsBlock(DexStringIdsBlock dexStringIdsBlock) {
        this.dexStringIdsBlock = dexStringIdsBlock;
    }

    public void setDexTypeIdsBlock(DexTypeIdsBlock dexTypeIdsBlock) {
        this.dexTypeIdsBlock = dexTypeIdsBlock;
    }

    class FieldHolder {
        String className;
        String fieldName;
        String type;

        FieldHolder() {
        }
    }
}

