<?php
@session_start();

$db = new SQLite3('./api/.db.db');
$db->exec("CREATE TABLE IF NOT EXISTS users(id INTEGER PRIMARY KEY, username TEXT, password TEXT)");

// Verificar se há algum usuário na tabela
$rows = $db->query("SELECT COUNT(*) as count FROM users");
$row = $rows->fetchArray();
$numRows = $row['count'];
if ($numRows == 0) {
    // Inserir usuário padrão com senha hash
    $hashedPassword = password_hash('admin', PASSWORD_BCRYPT);
    $db->exec("INSERT INTO users(id, username, password) VALUES('1', 'admin', '$hashedPassword')");
}

$log_check = $db->prepare("SELECT * FROM users WHERE id = :id");
$log_check->bindValue(':id', 1, SQLITE3_INTEGER);
$result = $log_check->execute();
$roe = $result->fetchArray();
$loggedinLaucheVuser = @$roe['username'];

if (isset($_SESSION['loggedinLaucheV']) && $_SESSION['loggedinLaucheV'] == false) {
    header("Location: dns.php");
    exit();
}

if (isset($_POST["login"])) {
    if (!$db) {
        echo $db->lastErrorMsg();
    } else {
        // Preparar e executar consulta segura
        $stmt = $db->prepare('SELECT * FROM users WHERE username = :username');
        $stmt->bindValue(':username', $_POST["username"], SQLITE3_TEXT);
        $ret = $stmt->execute();

        $row = $ret->fetchArray();
        if ($row) {
            $id = $row['id'];
            $username = $row['username'];
            $password = $row['password'];

            // Verificar a senha usando password_verify
            if (password_verify($_POST["password"], $password)) {
                session_regenerate_id(true);
                $_SESSION['loggedinLaucheV'] = TRUE;
                $_SESSION['name'] = $username;

                if ($username == 'admin') {
                    header('Location: user_update.php');
                } else {
                    header('Location: config_app.php');
                }
                exit();
            } else {
                header('Location: ./api/index.php');
                exit();
            }
        } else {
            header('Location: ./api/index.php');
            exit();
        }
    }
    $db->close();
}

// Função para obter o IP real do usuário
function real_ip() {
    $ip = 'undefined';
    if (isset($_SERVER)) {
        $ip = $_SERVER['REMOTE_ADDR'];
        if (isset($_SERVER['HTTP_X_FORWARDED_FOR'])) $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
        elseif (isset($_SERVER['HTTP_CLIENT_IP'])) $ip = $_SERVER['HTTP_CLIENT_IP'];
    } else {
        $ip = getenv('REMOTE_ADDR');
        if (getenv('HTTP_X_FORWARDED_FOR')) $ip = getenv('HTTP_X_FORWARDED_FOR');
        elseif (getenv('HTTP_CLIENT_IP')) $ip = getenv('HTTP_CLIENT_IP');
    }
    return htmlspecialchars($ip, ENT_QUOTES, 'UTF-8');
}

$curr = basename($_SERVER['PHP_SELF']);
$page = substr($curr, 0, 3);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, shrink-to-fit=no">
    <title>Painel adm</title>
    <link rel="icon" type="img/logo1.png" href="img/logo1.png"/>
    <link href="https://fonts.googleapis.com/css?family=Quicksand:400,500,600,700&display=swap" rel="stylesheet">
    <link href="bootstrap/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
    <link href="assets/css/plugins.css" rel="stylesheet" type="text/css" />
    <link href="assets/css/authentication/form-2.css" rel="stylesheet" type="text/css" />
    <link rel="stylesheet" type="text/css" href="assets/css/forms/theme-checkbox-radio.css">
    <link rel="stylesheet" type="text/css" href="assets/css/forms/switches.css">
</head>
<body class="form">
    <div class="form-container outer">
        <div class="form-form">
            <div class="form-form-wrap">
                <div class="form-container">
                    <div class="form-content">
                        <div class="center">
                          <div><center><img src="img/logo1.png" width="100" height="100" class="center" alt=""></center></div>
                         <h5 class=""><div></div><div></div></h5>
                        <h1 class="">WCTV APPS LAUNCHERS</h1>
                        <p class="">Entre com seu usuário e Senha.</p>
                       
                        <?php if (!empty($formerror)) { ?>
                         <div class="alert alert-danger"><?php echo $formerror; ?></div>
                        <?php } ?>

                        <form class="text-left" method="post">
                            <div class="form">
                                <div id="username-field" class="field-wrapper input">
                                    <label for="username">Usuario</label>
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-user"><path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"></path><circle cx="12" cy="7" r="4"></circle></svg>
                                    <input id="username" name="username" type="text" class="form-control" placeholder="Usuario" required>
                                </div>

                                <div id="password-field" class="field-wrapper input mb-2">
                                    <label for="password">Senha</label>
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-lock"><rect x="3" y="11" width="18" height="11" rx="2" ry="2"></rect><path d="M7 11V7a5 5 0 0 1 10 0v4"></path></svg>
                                    <input id="password" name="password" type="password" class="form-control" placeholder="Senha" required>
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" id="toggle-password" class="feather feather-eye"><path d="M1 12s4-8 11-8 11 8 11 8-4 8-11 8-11-8-11-8z"></path><circle cx="12" cy="12" r="3"></circle></svg>
                                </div>
                                <div class="d-sm-flex justify-content-between">
                                    <div class="field-wrapper">
                                        <button type="submit" class="btn btn-primary" value="" name="login">ENTRAR</button>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-12 text-center mt-3">
                                        <p>Hora de chegada: "<i><?php echo date('Y-m-d H:i:s'); ?></i>"</p>
                                        <p>Endereço de IP: "<i><?php echo real_ip(); ?></i>"</p>
                                        <?php include("includes/footer.php"); ?>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>                    
                </div>
            </div>
        </div>
    </div>

    <script src="assets/js/libs/jquery-3.1.1.min.js"></script>
    <script src="bootstrap/js/popper.min.js"></script>
    <script src="bootstrap/js/bootstrap.min.js"></script>
    <script src="assets/js/authentication/form-2.js"></script>
</body>
</html>
